---
aliases:
  - Research
---
##### Why? 
- To take feedback from what user pain points are and whether solution addresses them.
- To understand delighters and risks associated with a design decision tradeoff. (e.g. iPhone screen with a notch)
- Discovery should be focused on identifying and mitigating the 4 major risks that product management faces (as described by [Marty Cagan](https://svpg.com/four-big-risks/)):
	- **Value Risk** - does it meet real customer needs?
	- **Usability Risk** - will customers be able to use it easily?
	- **Feasibility Risk** - can we build it with the time, skills and technology we have?
	- **Viability Risk** - does it make economic sense? Will it work alongside our other business activities?
##### How to do it?
- **Discover:** Understand the issue rather than merely assuming it. It involves speaking to and spending time with people who are affected by the issues.
- **Define:** The insight gathered from the discovery phase can help to define the challenge in a different way.
- **Develop:** Give different answers to the clearly defined problem, seeking inspiration from elsewhere and co-designing with a range of different people.
- **Deliver:** Involves testing out different solutions at small-scale, rejecting those that will not work and improving the ones that will.
![[Pasted image 20230915235641.png|400]]

The Design Council's visual representation of their Double Diamond design and innovation process.

[[Product Design]] is crucial aspect to consider discovering and building the right experiences.

##### Teresa Torres 
How to discover customer needs: [Introduction to Modern Product Discovery - Teresa Torres - YouTube](https://www.youtube.com/watch?v=l7-5x0ra2tc&ab_channel=PRODUCTIZED)
Summary
1. Deciding what to build
2. Goal is to learn fast
	1. Are we meeting stakeholder needs?
	2. Can customers use our capability?
	3. Do customers want our solution?
	4. Are we solving a problem customers care about?
	5. Are we driving a desired outcome?
3. During UX research: How to decide whether we should do user interview vs run experiments vs surveys
	1. Define clear outcome and opportunities (problems and improvements) to drive the desired outcome
	2. Know what jobs customers want to be done
	3. This is where product strategy lives - what’s your moat, what’s your rightful market to win, what’s the next big trend that we should hop on to, do we have the viable solution to that problem? Does the solution drive desired outcome?
	4. This is where TAM expansion aspirations are built

##### From LinkedIn: UX Foundations: Research
[[UX Research Methods.pdf]]
- Usability testing
- Interviews
- Card sorts
- Eye tracking / scroll tracking
- Multivariate testing
    - A/B test is when you only test 2 options
    - Tools: Optimizely, visual website optimizer, Google website optimizer
    - Article: [https://www.smashingmagazine.com/2010/06/the-ultimate-guide-to-a-b-testing/](https://www.smashingmagazine.com/2010/06/the-ultimate-guide-to-a-b-testing/)
- Desirability study: give design options and ask what the users associate to with the design
- Diary studies
- Personas - learn behavior, goals and usage